import {ParsedQuery} from 'query-string';

import {UTM_QUERY_PARAMS} from 'constants/utm/EUtmQueryParams';

import {IUtmQueryParams} from 'types/common/IQueryParams';

import {
    filterQueryByParamList,
    checkQueryStringParam,
} from 'utilities/location/filterQueryByParamList';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

/* Helpers */
export const getUtmQueryParamsByQuery = filterQueryByParamList<
    IUtmQueryParams,
    ParsedQuery
>(UTM_QUERY_PARAMS, checkQueryStringParam);

/**
 * Достает из query utm метки
 */
export const getUtmQueryParamsByBrowserHistory = (): IUtmQueryParams => {
    return getUtmQueryParamsByQuery(getQueryByBrowserHistory());
};
