import TEnum from 'types/Enum';

/**
 * Возвращает типизированное значение из переданного enum, если оно в нем есть или undefined.
 * Применяется для того, чтобы понять, что строка/число принадлежит нужному enum
 * @param value
 * @param enumInstance
 */
export default function getValueFromEnum<T extends TEnum<T>>(
    value: string,
    enumInstance: T,
): T[keyof T] | undefined {
    const found = Object.entries(enumInstance)
        // Убираем числовые ключи, потому что зачем-то числовой enum добавляет обратное сочетание {"значение": "ключ"} в объект с enum
        .filter(([key]) => isNaN(parseInt(key, 10)))
        .find(([, enumValue]) => enumValue === value);

    if (found) {
        return found[1] as T[keyof T];
    }
}
