import {useDispatch, useSelector} from 'react-redux';
import {useCallback, useEffect, useRef, useState} from 'react';
import {ActionCreator} from 'typesafe-actions';
import {Selector} from 'reselect';

import {previewState} from 'reducers/utils/preview';
import {StoreInterface} from 'reducers/storeTypes';

// Магический хук который задерживает экшен на заданное время, но позволяет
// получить состояние, которое было бы если экшен выполнился немедленно
export const useAsyncAction = (
    selector: Selector<StoreInterface, any>,
    handler: () => void,
    delay = 700,
): [
    ReturnType<typeof selector>,
    (action: ActionCreator<any>, value: any) => void,
] => {
    const dispatch = useDispatch();
    const selectorResult = useSelector(selector);
    const [data, setData] = useState(selectorResult);
    const [handled, setHandled] = useState(true);
    const handlerTimeout = useRef<number>();

    const asyncHandler = useCallback(
        (action, value) => {
            window.clearTimeout(handlerTimeout.current);

            setHandled(false);

            const statePreview = dispatch(previewState(action(value)));
            // @ts-ignore
            const newData = selector(statePreview);

            setData(newData);

            handlerTimeout.current = window.setTimeout(() => {
                handler();
                setHandled(true);
            }, delay);
        },
        [dispatch, selector, handler, delay],
    );

    useEffect(() => {
        if (handled) {
            setData(selectorResult);
        }
    }, [handled, selectorResult, setData]);

    return [data, asyncHandler];
};
