import {useEffect} from 'react';

import {EToggler} from 'types/common/togglers/EToggler';

import useCookieToggler from 'utilities/hooks/useCookieToggler';
import {adBlockManager} from 'utilities/adBlockManager/adBlockManager';

const MS_AFTER_CHECK_ADBLOCK = 5000;

let cashedValue: boolean | undefined;
let isChecked = false;

/**
 * Хук возвращает признак того, включен ли у пользователя AdBlock.
 * Возвращает кэшированное значение в целях оптимизации, как следствие,
 * при переключении AdBlock, значение обновится через одну перезагрузку страницы.
 */
export default function useCashedAdBlockIsEnabled(): boolean {
    const {value: isEnabledByCookie, toggle} = useCookieToggler(
        EToggler.ADBLOCK_IS_ENABLED,
    );

    useEffect(() => {
        if (isChecked) {
            return;
        }

        const timeout = setTimeout(async () => {
            isChecked = true;

            const adBlockIsEnabled = await adBlockManager.isEnabled();

            if (adBlockIsEnabled !== isEnabledByCookie) {
                toggle();
            }
        }, MS_AFTER_CHECK_ADBLOCK);

        return (): void => {
            clearTimeout(timeout);
        };
    }, [isEnabledByCookie, toggle]);

    if (__SERVER__) {
        return isEnabledByCookie;
    }

    if (cashedValue === undefined) {
        cashedValue = isEnabledByCookie;
    }

    return cashedValue;
}
