import {useEffect, useRef, MutableRefObject} from 'react';

export default function useConnectedRef<T>(value: T): MutableRefObject<T> {
    const connectedRef = useRef(value);

    useEffect(() => {
        connectedRef.current = value;
    }, [value]);

    return connectedRef;
}
