import {useState} from 'react';
import Cookie, {CookieAttributes} from 'js-cookie';

import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

export function useCookie(name: string): {
    value: undefined | string;
    setValue(value: string, options?: CookieAttributes): void;
    clearValue(): void;
} {
    const [value, setValue] = useState<string | undefined>(Cookie.get(name));

    return {
        value,
        setValue: useImmutableCallback(v => {
            Cookie.set(name, v);
            setValue(v);
        }),
        clearValue: useImmutableCallback(() => {
            Cookie.remove(name);
            setValue(undefined);
        }),
    };
}
