import {useDispatch, useSelector} from 'react-redux';
import cookies from 'js-cookie';

import {
    STORED_TOGGLERS_COOKIE_KEY,
    TOGGLERS_EXPIRES_DAYS,
} from 'constants/togglers';

import {EToggler} from 'types/common/togglers/EToggler';

import {setToggler} from 'reducers/common/togglers/actions';

import togglersSelector from 'selectors/common/togglers/togglersSelector';

import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

export default function useCookieToggler(togglerKey: EToggler): {
    value: boolean;
    toggle(): void;
} {
    const dispatch = useDispatch();

    const togglers = useSelector(togglersSelector);

    const togglerValue = togglers[togglerKey];

    const toggle = useImmutableCallback(() => {
        dispatch(
            setToggler({
                togglerKey,
                value: !togglerValue,
            }),
        );

        cookies.set(
            STORED_TOGGLERS_COOKIE_KEY,
            JSON.stringify({
                ...togglers,
                [togglerKey]: !togglerValue,
            }),
            {expires: TOGGLERS_EXPIRES_DAYS},
        );
    });

    return {
        value: togglerValue,
        toggle,
    };
}
