import {useState, useEffect} from 'react';

/**
 * Хук возвращает признак того, нужно ли рендерить комопнент,
 * если рендер происходит асинхронно.
 */
export default function useDelayRender() {
    const [canRender, setCanRender] = useState(false);

    useEffect(() => {
        requestAnimationFrame(() => {
            setCanRender(true);
        });
    }, []);

    return canRender;
}
