import {Action} from 'redux';

import {
    CustomDispatch,
    CustomThunkAction,
} from 'reducers/trains/customDispatch';

import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

export default function useDispatchedAction<Data extends unknown[]>(
    action: (...data: Data) => Action | CustomThunkAction<unknown>,
    dispatch: CustomDispatch,
): (...data: Data) => void {
    return useImmutableCallback((...data: Data) => {
        dispatch((action as any)(...data));
    });
}
