import {useState, useEffect} from 'react';

type TUseFetchState<Data> =
    | {loading: true; data: null; error: null}
    | {loading: false; data: Data; error: null}
    | {loading: false; data: null; error: Error};

export function useFetch<Data>(
    fetcher: () => Promise<Data>,
    deps?: readonly any[],
): TUseFetchState<Data> {
    const [state, setState] = useState<TUseFetchState<Data>>({
        loading: true,
        data: null,
        error: null,
    });

    useEffect(() => {
        let skip = false;

        setState({loading: true, data: null, error: null});

        fetcher().then(
            data => {
                if (!skip) {
                    setState({loading: false, data, error: null});
                }
            },
            error => {
                if (!skip) {
                    setState({loading: false, data: null, error});
                }
            },
        );

        return () => {
            skip = true;
        };
    }, deps);

    return state;
}
