import {useEffect} from 'react';

import {useForceUpdate} from 'utilities/hooks/useForceUpdate';

export function useIntervalForceUpdate(intervalMs: number | null): void {
    const forceUpdate = useForceUpdate();

    useEffect(() => {
        if (!intervalMs) {
            return;
        }

        const interval = window.setInterval(() => {
            forceUpdate();
        }, intervalMs);

        return () => {
            window.clearInterval(interval);
        };
    }, [forceUpdate, intervalMs]);
}
