import {matchPath, useLocation} from 'react-router-dom';
import {useMemo} from 'react';

export function useIsOnPage(
    paths: string | string[],
    {
        exact = true,
        strict = false,
    }: {
        exact?: boolean;
        strict?: boolean;
    } = {},
): boolean {
    const location = useLocation();

    return useMemo(() => {
        const pathsSet = typeof paths === 'string' ? [paths] : paths;

        return pathsSet.some(path => {
            return Boolean(
                matchPath(location.pathname, {
                    path,
                    exact,
                    strict,
                }),
            );
        });
    }, [exact, location.pathname, paths, strict]);
}
