import {useEffect} from 'react';

import {
    useNeedToLoadDynamicResource,
    ILoadDynamicResourceOptions,
} from 'utilities/hooks/useNeedToLoadDynamicResource';
import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

export const useLoadDynamicResource = (
    loader: () => unknown,
    options?: ILoadDynamicResourceOptions,
): void => {
    const immutableLoader = useImmutableCallback(loader);
    const needToLoadDynamicResource = useNeedToLoadDynamicResource(options);

    useEffect(() => {
        if (needToLoadDynamicResource) {
            immutableLoader();
        }
    }, [immutableLoader, needToLoadDynamicResource]);
};
