import {useDispatch, useSelector} from 'react-redux';

import {setIsNetworkOnlineAction} from 'reducers/common/isNetworkOnline/actions';

import isNetworkOnlineSelector from 'selectors/common/isNetworkOnlineSelector';

import {useEventListener} from 'utilities/hooks/useEventListener';

export default function useNetwork(): boolean {
    const dispatch = useDispatch();

    useEventListener('online', () => {
        dispatch(setIsNetworkOnlineAction(false));
    });

    useEventListener('offline', () => {
        dispatch(setIsNetworkOnlineAction(false));
    });

    return useSelector(isNetworkOnlineSelector);
}
