import {useEffect} from 'react';

import pageManager, {TOnLoadCallback} from 'utilities/pageManager/pageManager';
import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

export const useOnPageLoad = (callback: TOnLoadCallback): void => {
    const immutableCallback = useImmutableCallback(callback);

    useEffect(() => {
        if (pageManager.pageLoadInfo.loaded) {
            immutableCallback(pageManager.pageLoadInfo);

            return;
        }

        return pageManager.addOnLoadCallback(immutableCallback);
    }, [immutableCallback]);
};
