import {IDevice} from 'reducers/common/commonReducerTypes';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import {TBoxSizes} from 'components/Box/Box';

import cx from './usePadding.scss';

export interface ISize {
    top: TBoxSizes;
    right: TBoxSizes;
    bottom: TBoxSizes;
    left: TBoxSizes;
}

export interface ISizeByDevice {
    MOBILE: ISize;
    DESKTOP: ISize;
}

function preparePaddings({isMobile}: IDevice, sizes: ISizeByDevice): ISize {
    if (isMobile) {
        return sizes.MOBILE;
    }

    return sizes.DESKTOP;
}

function preparePaddingsClassNames(
    deviceType: IDevice,
    sizes: ISizeByDevice,
): string {
    const {top, right, bottom, left} = preparePaddings(deviceType, sizes);

    return cx(
        `top_${top}`,
        `right_${right}`,
        `bottom_${bottom}`,
        `left_${left}`,
    );
}

export function usePadding(sizes: ISizeByDevice): string {
    const deviceType = useDeviceType();

    return preparePaddingsClassNames(deviceType, sizes);
}
