import {LoadableComponent} from '@loadable/component';

import {useLoadDynamicResource} from 'utilities/hooks/useLoadDynamicResource';
import {ILoadDynamicResourceOptions} from 'utilities/hooks/useNeedToLoadDynamicResource';

const DEFAULT_LOAD_RESOURCE_OPTIONS: ILoadDynamicResourceOptions = {
    timeoutAfterNavigation: 3000,
    maxProportionTimeout: 5000,
    timeoutProportion: 10,
};

export default function usePreloadChunks(
    chunks: LoadableComponent<any>[],
    options?: ILoadDynamicResourceOptions,
): void {
    useLoadDynamicResource(
        () => {
            chunks.forEach(chunk => {
                chunk.preload();
            });
        },
        {
            ...DEFAULT_LOAD_RESOURCE_OPTIONS,
            ...options,
        },
    );
}
