import {useBoolean} from 'utilities/hooks/useBoolean';
import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

//todo use print-js after up and resolve https://github.com/crabbly/Print.js/issues/528

type TPrintOptions = import('forkedPackages/print-js/src/index').Configuration;

// SSR escape
let printJs: typeof import('forkedPackages/print-js/src/index') | undefined;

if (typeof window !== 'undefined') {
    printJs = require('forkedPackages/print-js/dist/print.js');
}

interface IPrintOptions extends TPrintOptions {}

interface IPrintInfo {
    isPrinting: boolean;
    startPrinting(): void;
}

export function usePrint(options: IPrintOptions): IPrintInfo {
    const {
        value: isPrinting,
        setTrue: startPrinting,
        setFalse: stopPrinting,
    } = useBoolean(false);

    return {
        isPrinting,
        startPrinting: useImmutableCallback(() => {
            startPrinting();
            printJs?.({
                ...options,
                onLoadingEnd: stopPrinting,
                onPdfOpen: stopPrinting,
                onError: stopPrinting,
            });
        }),
    };
}
