import {useEffect, useState} from 'react';

export function useScrollRestoration(restoration: 'auto' | 'manual'): void {
    const [initialRestoration] = useState(restoration);

    useEffect(() => {
        history.scrollRestoration = restoration;

        return (): void => {
            history.scrollRestoration = initialRestoration;
        };
    }, [restoration, initialRestoration]);
}
