import {useCallback} from 'react';

export const useTimeout = (
    callback: () => void,
    milliseconds: number,
): (() => void) => {
    return useCallback(() => {
        const timeout = setTimeout(callback, milliseconds);

        return (): void => clearTimeout(timeout);
    }, [callback, milliseconds]);
};
