import {useCallback} from 'react';
import {v4 as uuid} from 'uuid';

const ATTRS_TO_REPLACE = ['mask', 'fill', 'clipPath'];

function replaceChildAttrs(
    root: SVGSVGElement,
    attrName: string,
    attrOldValue: string,
    attrNewValue: string,
): void {
    Array.from(
        root.querySelectorAll(`[${attrName}="${attrOldValue}"]`),
    ).forEach(refItem => {
        refItem.setAttribute(attrName, attrNewValue);
    });
}

export function useUniqSvg<T extends HTMLElement>(): (root: T) => void {
    return useCallback((root: T) => {
        if (!root) {
            return;
        }

        Array.from(root.querySelectorAll('svg')).forEach(svgRoot => {
            Array.from(svgRoot.querySelectorAll('[id]')).forEach(
                svgDefElement => {
                    const oldId = svgDefElement.getAttribute('id');
                    const newId = uuid();

                    svgDefElement.setAttribute('id', newId);
                    ATTRS_TO_REPLACE.forEach(attrName =>
                        replaceChildAttrs(
                            svgRoot,
                            attrName,
                            `url(#${oldId})`,
                            `url(#${newId})`,
                        ),
                    );
                },
            );
        });
    }, []);
}
