import {useEffect} from 'react';

import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

export function useWebSocket<Event>(
    url: string,
    onMessage: (event: Event) => unknown,
): void {
    const messageCallback = useImmutableCallback(onMessage);

    useEffect(() => {
        const webSocket = new WebSocket(url);

        webSocket.addEventListener('message', event => {
            if (event.data !== 'ping') {
                messageCallback(JSON.parse(event.data));
            }
        });

        return () => {
            webSocket.close();
        };
    }, [messageCallback, url]);
}
