import {useContext} from 'react';

import {IWhiteLabelConfig} from 'types/common/whiteLabel/IWhiteLabelConfig';

import WhiteLabelConfigContext from 'contexts/WhiteLabelConfigContext';

export function useWhiteLabelConfig(): {
    isWhiteLabel: boolean;
    config: IWhiteLabelConfig | null;
} {
    const config = useContext<IWhiteLabelConfig | null>(
        WhiteLabelConfigContext,
    );

    return {isWhiteLabel: Boolean(config), config};
}
