import {useState, useCallback} from 'react';

import {useEventListener} from 'utilities/hooks/useEventListener';
import {getDocumentScrollTop} from 'utilities/dom/getDocumentScrollTop';

export function useWindowScrollTop() {
    const [scrollTop, setScrollTop] = useState(getDocumentScrollTop());

    useEventListener(
        'scroll',
        useCallback(() => setScrollTop(getDocumentScrollTop()), []),
    );

    return scrollTop;
}
