import {
    EHotelBadgeType,
    IHotelOrOfferBadge,
} from 'types/hotels/offer/IHotelOffer';

export const YANDEX_PLUS_BADGES = [
    EHotelBadgeType.YANDEX_PLUS,
    EHotelBadgeType.YANDEX_PLUS_SPECIAL,
    EHotelBadgeType.YANDEX_PLUS_CULTURAL_DREAMS,
];

export function getYandexPlusBadge(
    badges?: IHotelOrOfferBadge[],
): IHotelOrOfferBadge | undefined {
    return badges?.find(badge => isYandexPlusBadge(badge));
}

export function isYandexPlusBadge(badge?: IHotelOrOfferBadge): boolean {
    return (
        badge?.id === EHotelBadgeType.YANDEX_PLUS ||
        badge?.id === EHotelBadgeType.YANDEX_PLUS_SPECIAL ||
        badge?.id === EHotelBadgeType.YANDEX_PLUS_CULTURAL_DREAMS
    );
}
