import {TImage} from 'types/common/TImage';

const isImageWithSize = (image: TImage): image is Required<TImage> =>
    Boolean(image.size);

const sizeComparator = (a: Required<TImage>, b: Required<TImage>): number =>
    b.size.width - a.size.width;

const mapImageToSrcSetString = (image: Required<TImage>): string =>
    `${image.src} ${image.size.width}w`;

export default function getSrcSetString(images?: TImage[]): string | undefined {
    if (!images) {
        return;
    }

    /*
        Кладем в начале srcSet картинку с максимальным размером,
        потому что есть браузеры, которые не поддерживают запись
        в виде 150w (например, Safari iOS < 9.x), а поддерживают только запись вида 2x,
        в таком случае браузер берет первую картинку из srcSet
     */

    const preparedImages = images
        .filter(isImageWithSize)
        .sort(sizeComparator)
        .map(mapImageToSrcSetString)
        .join(', ');

    return preparedImages || undefined;
}
