import IIziTravelTourInfo from 'types/trips/IIziTravelTourInfo';

import {logError} from 'utilities/logger/logError';

import * as iziTravelTourType from 'i18n/happyPage_iziTravelTourType';

import getLocalizedTourCategory from './getLocalizedTourCategory';

export default function getLocalizedTourType(tour: IIziTravelTourInfo): string {
    switch (tour.type) {
        case 'museum':
            return iziTravelTourType.museum();
        case 'tour':
            return getLocalizedTourCategory(tour);

        default: {
            logError({
                message: `Неизвестный тип тура: ${tour.type}`,
                block: 'getLocalizedType',
            });

            return tour.type;
        }
    }
}
