import * as localStorage from 'local-storage';

import {
    TRAVEL_STORAGE_KEY,
    BOOK_CONTACTS_KEY,
} from 'constants/storage/storageKeys';
import {EFormKey} from 'constants/form/EFormKey';

import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {TBookingContacts} from 'components/BookingContactsForm/BookingContactsForm';

export interface IStorageContacts<T extends TBookingContacts> {
    contacts: T;
    userUid: Nullable<string>;
}

export function saveBookingContacts<T extends TBookingContacts>(
    formKey: EFormKey,
    contacts: T,
    userInfo: TUserInfo,
): void {
    const userUid = ('uid' in userInfo && userInfo.uid) || null;

    localStorage.set<IStorageContacts<T>>(
        `${TRAVEL_STORAGE_KEY}/${BOOK_CONTACTS_KEY}/${formKey}`,
        {
            contacts,
            userUid,
        },
    );
}
