import _pickBy from 'lodash/pickBy';
import {ParsedQuery} from 'query-string';

// TODO: подумать о переименовании т.к. функция сама по себе не фильтрует, а является фабрикой фильтра
export function filterQueryByParamList<T, S extends T>(
    queryList: (keyof T)[],
    predicate: (queryValue: S[keyof S]) => boolean,
) {
    return (query: S): T => {
        /* prettier-ignore */
        // @ts-ignore TS2769
        return _pickBy(query,
            (queryValue: S[keyof S], queryKey: keyof S): boolean =>
                queryList.includes(queryKey as keyof T) && predicate(queryValue),
        );
    };
}

export const checkQueryStringParam = (
    queryValue: ParsedQuery[keyof ParsedQuery],
): boolean => typeof queryValue === 'string' && Boolean(queryValue);
