import {unknownToError} from '../error';

export function logWarning(
    options: Omit<IRumErrorOptions, 'level' | 'service'>,
    error?: Error | unknown,
): void {
    try {
        window.Ya.Rum.logError(
            {
                ...options,
                service: 'front.portal',
                level: window.Ya.Rum.ERROR_LEVEL.WARN,
            },
            unknownToError(error),
        );
    } catch (e) {}
}
