export function median(values: number[]): number {
    const len = values.length;

    if (len === 0) {
        return NaN;
    }

    const width = 2 - (len % 2);
    const idx = (len - width) / 2;

    return (
        values
            .slice()
            .sort((a, b) => a - b)
            .slice(idx, idx + width)
            .reduce((acc, x) => acc + x, 0) / width
    );
}
