import {TQueryTypeWithArray} from 'types/common/IQueryParams';

import {reachGoal} from 'utilities/metrika';

const METRIKA_PREFIX = /^(m__)([\w-]+)$/;

/**
 * Отсылаем в метрику события из параметров запроса
 * @param {Object} query - параметры запроса
 * @return {void}
 */
export default function handleMetrikaQuery(
    query: Record<string, TQueryTypeWithArray>,
): void {
    Object.keys(query)
        .map(key => METRIKA_PREFIX.exec(key))
        .filter((item): item is RegExpExecArray => Array.isArray(item))
        // Забираем группу после m__, если она есть
        .map(item => item[2])
        .filter(item => Boolean(item))
        .forEach(goal => reachGoal(goal));
}
