import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import {ECountryRestrictionsColor} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';

import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

export interface IMetrikaAviaBadPartnersParams {
    badPartners: Record<string, boolean>;
}

export interface IMetrikaAviaInvalidSearchParams {
    invalidSearchParams: Partial<IAviaParams>;
}

export interface IMetrikaAviaCovidBanner {
    /**
     * когда цвет определялся на фронте, отправляли метрику с
     * опечаткой, поэтому, чтобы метрика не поплыла, подменяем
     * на старую 'grey'
     */
    covidBannerColor: ECountryRestrictionsColor | 'grey';
}

interface IMetrikaAviaTariffWithFreeRefundRatioParams {
    tariffWithFreeRefundRatio: number;
}

interface IMetrikaAviaTariffWithChargedRefundRatioParams {
    tariffWithChargedRefundRatio: number;
}

interface IMetrikaAviaTariffWithChargedChangeRationParams {
    /** доля сегментов с платным обменом относительно всех сегментов - отправляется при завершении поиска */
    tariffWithChargedChangeRatio: number;
}
interface IMetrikaAviaTariffWithFreeChangeRationParams {
    /** доля сегментов с бесплатным обменом относительно всех сегментов - отправляется при завершении поиска */
    tariffWithFreeChangeRatio: number;
}

interface IMetrikaAviaBookingParams {
    withPaymentErrorModal: number;
}

interface IMetrikaAviaSortParams {
    sortType: EAviaResultsSortType;
}

export type TGoalRefundValue = 'free' | 'charged' | 'no' | 'unknown';
export type TGoalChangingValue = TGoalRefundValue;
export type TGoalBaggageValue = 'yes' | 'no';

export interface IMetrikaAviaTariffChoose {
    baggage: TGoalBaggageValue;
    refund: TGoalRefundValue;
}

export interface IMetrikaAviaTariffClick {
    count: number;
}

export type TMetrikaAviaParams =
    | IMetrikaAviaBadPartnersParams
    | IMetrikaAviaInvalidSearchParams
    | IMetrikaAviaCovidBanner
    | IMetrikaAviaTariffWithFreeRefundRatioParams
    | IMetrikaAviaTariffWithChargedRefundRatioParams
    | IMetrikaAviaTariffWithChargedChangeRationParams
    | IMetrikaAviaTariffWithFreeChangeRationParams
    | IMetrikaAviaTariffChoose
    | IMetrikaAviaTariffClick
    | IMetrikaAviaBookingParams
    | IMetrikaAviaSortParams;
