import {EProjectName} from 'constants/common';

import {IAffiliateParams} from 'types/affiliate/IAffiliateParams';
import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';
import IAttributionUTMDataValues from 'types/attribution/IAttributionUTMDataValues';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';
import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {FeaturesState} from 'reducers/common/commonReducerTypes';

export type TMetrikaCommonParams =
    | IMetrikaCommonSubscriptionsParams
    | IMetrikaCommonProjectNameParams
    | IMetrikaCommonFeaturesParams
    | IMetrikaCommonIntlSupportParams
    | IMetrikaCommonAttributionParams
    | IMetrikaCommonCertificateParams
    | IMetrikaCommonPlusModeParams;

export interface IMetrikaCommonSubscriptionsParams {
    common: {
        subscriptions: {
            source: ESubscriptionSource;
            vertical: ESubscriptionVerticalName;
        };
    };
}

export interface IMetrikaCommonProjectNameParams {
    project: EProjectName;
}

export interface IMetrikaCommonFeaturesParams {
    features: FeaturesState;
    common: {
        userLoggedIn: boolean;
        isPlusUser: boolean;
    };
}

interface IMetrikaCommonIntlSupportParams {
    common: {
        intlSupport: string;
    };
}

interface IMetrikaCommonCertificateParams {
    common: {
        headerCertificateClick?: boolean;
        sideSheetCertificateClick?: boolean;
    };
}

export interface IMetrikaCommonAttributionParams {
    common: {
        affiliate?: IAffiliateParams;
        utm?: IAttributionUTMDataValues;
    };
}

interface IMetrikaCommonPlusModeParams {
    common: {
        plusMode: EYandexPlusApplicationMode;
    };
}
