import {IBookOfferPrice} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {EColorZone} from 'types/hotels/search/EColorZone';

export type TMetrikaHotelsParams =
    | undefined
    | IMetrikaHotelsOfferErrorParams
    | IMetrikaHotelsOrderErrorParams
    | IMetrikaHotelsPaymentErrorParams
    | IMetrikaHotelsPayPriceParams
    | IMetrikaHotelsVisitedBookPageParams
    | IMetrikaHotelsVisitedRegionPageParams
    | IMetrikaHotelsVisitedHotelPageParams
    | IMetrikaHotelsVisitedSearchPageParams
    | IMetrikaHotelsVoucherParams
    | IMetrikaHotelsFilterChangeParams
    | IMetrikaHotelsAccordeonChangeParams
    | IMetrikaHotelsLongSearchParams
    | IMetrikaHotelsReviewsMoreClickParams
    | IMetrikaHotelsReviewsStarsClickParams
    | IMetrikaHotelsReviewsTagClickParams
    | IMetrikaHotelsMirParams
    | IMetrikaHotelsDesktopFullscreenMapParams;

export interface IMetrikaHotelsOfferErrorParams {
    offerError: string;
}

export interface IMetrikaHotelsOrderErrorParams {
    orderError?: string;
}

export interface IMetrikaHotelsPaymentErrorParams {
    paymentError: string;
}

export interface IMetrikaHotelsPayPriceParams {
    payPrice: IBookOfferPrice;
}

export interface IMetrikaHotelsVisitedBookPageParams {
    didVisitBookingPage: number;
}

export interface IMetrikaHotelsVisitedRegionPageParams {
    didVisitSeoRegionPage: number;
}

export interface IMetrikaHotelsVisitedHotelPageParams {
    didVisitHotelPage: number;
}

export interface IMetrikaHotelsVisitedSearchPageParams {
    didVisitSearchPage: number;
}

export interface IMetrikaHotelsVoucherParams {
    // eslint-disable-next-line camelcase
    voucher_type: 'voucher_print' | 'voucher_download';
}

export interface IMetrikaHotelsFilterChangeParams {
    filters: {apply: Record<string, string>} | {unset: Record<string, string>};
}

export interface IMetrikaHotelsAccordeonChangeParams {
    accordeons: {apply: Record<string, true>} | {unset: Record<string, true>};
}

export interface IMetrikaHotelsLongSearchParams {
    searchPage:
        | {
              longSearch: number;
          }
        | {
              searchtime: Partial<Record<EColorZone, number>>;
          }
        | {
              requestsTimeSumBack: Partial<Record<EColorZone, number>>;
              requestsTimeSumFront?: Partial<Record<EColorZone, number>>;
          };
}

export interface IMetrikaHotelsDesktopFullscreenMapParams {
    searchPage: {
        didFullscreenDesktopMapView: number;
    };
}

export interface IMetrikaHotelsReviewsMoreClickParams {
    moreReviewsOffset: number;
    activeKeyPhrase?: string;
}
export interface IMetrikaHotelsReviewsStarsClickParams {
    reviewStars: number;
}

export interface IMetrikaHotelsReviewsTagClickParams {
    activeKeyPhrase: string;
}

export interface IMetrikaHotelsMirParams {
    mir:
        | {
              badgeClick: true;
          }
        | {
              popupLinkClick: true;
          };
}
