import React from 'react';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';
import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {ETrainsOrderInfoWarningCode} from 'server/api/TrainsBookingApi/types/ETrainsOrderInfoWarningCode';

import {IUnexpectedOrderStates} from 'projects/trains/lib/order/getUnexpectedStates';

export type TMetrikaTrainsParams =
    | IMetrikaTrainsRefundErrorParams
    | IMetrikaTrainsOrderPageWarningParams
    | IMetrikaTrainsSegmentsRatioParams
    | TMetrikaTomorrowSegmentsParams
    | IMetrikaTrainsAvailableRequirementsParams
    | IMetrikaTrainsSearchTransfersWithoutPriceParams
    | IMetrikaTrainsServiceClassChangedParams
    | TMetrikaTrainsUnexpectedOrderStatesParams
    | IMetrikaTrainsOrderUidParams
    | IMetrikaTrainsTravelerDocumentsCountParams
    | IMetrikaTrainsSearchPageInconsistencyParams
    | IMetrikaTrainsLocalStoragePassengersDataParams
    | IMetrikaTrainsOrderErrorParams
    | IMetrikaTrainsElectronicRegistrationChangeFailedParams
    | IMetrikaTrainsPassengerParams
    | IMetrikaTrainsCoachSchemeLogParams;

export interface IMetrikaTrainsRefundErrorParams {
    // eslint-disable-next-line camelcase
    refund_error: string;
}

export interface IMetrikaTrainsOrderPageWarningParams {
    // eslint-disable-next-line camelcase
    order_page_warning: ETrainsOrderInfoWarningCode | string | undefined;
}

export interface IMetrikaTrainsSegmentsRatioParams {
    'segments-ratio': {
        [ratio: number]: string;
    };
}

export type TMetrikaTomorrowSegmentsParams =
    | {onlyTomorrowSegments: boolean}
    | {onlyNextDateSegments: boolean};

export interface IMetrikaTrainsAvailableRequirementsParams {
    availableRequirements: Record<string, string>;
}

export interface IMetrikaTrainsSearchTransfersWithoutPriceParams {
    searchTransfersWithoutPricePercentage: number;
}

export interface IMetrikaTrainsServiceClassChangedParams {
    // eslint-disable-next-line camelcase
    service_class_changed: boolean;
}

export type TMetrikaTrainsUnexpectedOrderStatesParams = IUnexpectedOrderStates;

export interface IMetrikaTrainsOrderUidParams {
    orderUid: string | string[] | null | undefined;
}

export interface IMetrikaTrainsTravelerDocumentsCountParams {
    travelerDocumentsCount: Record<string, number>;
}

export interface IMetrikaTrainsSearchPageInconsistencyParams {
    searchPagePriceInconsistency?: number;
    searchPagePlaceInconsistency?: number;
}

export interface IMetrikaTrainsLocalStoragePassengersDataParams {
    localStoragePassengersData: boolean;
}

export interface IMetrikaTrainsOrderErrorParams {
    // eslint-disable-next-line camelcase
    order_error: Record<ORDER_STEP, Record<EOrderErrorType, React.ReactNode>>;
}

export interface IMetrikaTrainsElectronicRegistrationChangeFailedParams {
    // eslint-disable-next-line camelcase
    change_er_error: string;
}

export interface IMetrikaTrainsPassengerParams {
    passengersStep: {
        /** Заказ был создан с дополнительными контактами */
        withAdditionalContacts?: boolean;
        /** Заказ был создан с бонусными картами */
        withBonusCards?: boolean;
        /** Имя поля у которого показали/поменяли ошибку */
        blurError?: string;
        /** Имя поля у которого показали ошибку на submit */
        submitErrors?: string;
    };
}

export enum EMetrikaTrainsSchemeErrorReason {
    EMPTY_SCHEME_ID = 'emptySchemeId',
    SCHEME_RENDER_ERROR = 'schemeRenderError',
}

export interface IMetrikaTrainsCoachSchemeLogParams {
    schemeParams: {
        departure: string;
        trainNumber: string;
        coachNumber: string;
        coachSubtypeCode: string;
        serviceClassCode: string;
        errorReason?: EMetrikaTrainsSchemeErrorReason;
    };
}
