import {throttle} from 'lodash';
import {useCallback} from 'react';

import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';
import {TMetrikaParams} from 'utilities/metrika/types/params/all';

import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

import {reachGoal} from '.';

export const useReachGoal = (
    target?: TMetrikaGoal,
    args?: TMetrikaParams[],
): (() => void) => {
    return useCallback(() => {
        if (target) {
            if (args) {
                reachGoal(target, ...args);
            } else {
                reachGoal(target);
            }
        }
    }, [target, args]);
};

export const METRIKA_SEND_DELAY = 500;

export const useReachGoalThrottle = (
    target: TMetrikaGoal,
    args?: TMetrikaParams[],
    delay: number = METRIKA_SEND_DELAY,
): (() => void) => {
    return useImmutableCallback(
        throttle(
            () => (args ? reachGoal(target, ...args) : reachGoal(target)),
            delay,
        ),
    );
};
