import clamp from 'lodash/clamp';

// Source: https://github.com/sghall/react-compound-slider/blob/master/src/scales/DiscreteScale.ts
// В открытую не экспортируется, поэтому для надежности логика округления вынесена сюда

const roundToInRange = (range: number[], step: number, x: number): number => {
    const [left, right] = range;

    // Нормируем в промежуток от [left, right]
    const clampedX = clamp(x, left, right);

    // Считаем, сколько "целых" шагов поместилось в наше значение
    const stepsInValue = Math.round((clampedX - left) / step);

    // Переводим обратно к нашему интервалу
    const p = step * stepsInValue + left;

    // Еще раз нормируем, если вдруг вылезли за границу
    return clamp(p, left, right);
};

export default roundToInRange;
