import {EProjectName} from 'constants/common';

import ICrossLinksGalleryItem from 'projects/index/IndexApp/components/CrossLinksGallery/types/ICrossLinksGalleryItem';
import {isNotUndefined} from 'types/utilities';

import {ICrossLinksState} from 'reducers/common/crossLinks/reducer';

import getCrossLinksUrl from 'utilities/url/getCrossLinksUrl';
import getCrossLinkImageUrlByType from 'utilities/url/getCrossLinkImageUrlByType';
import {CHAR_EM_DASH} from 'utilities/strings/charCodes';

export default function prepareCrossLinksForGallery(
    crossLinks: ICrossLinksState,
    project: EProjectName,
): ICrossLinksGalleryItem[] {
    const allItems = [
        ...crossLinks.response.recipes.directions,
        ...crossLinks.response.crossLinks.flatMap(
            crossLink => crossLink.directions,
        ),
    ];

    return allItems.map(direction => {
        const {from, to, imageUrl, minPrice} = direction;

        return {
            id: `${from?.slug}-${to.slug}`,
            url: getCrossLinksUrl({
                type: project,
                fromSlug: from?.slug,
                toSlug: to.slug,
            }),
            image: getCrossLinkImageUrlByType(imageUrl, 'normal'),
            price: minPrice,
            title: [
                from?.linguistics.nominativeCase,
                to.linguistics.nominativeCase,
            ]
                .filter(isNotUndefined)
                .join(` ${CHAR_EM_DASH} `),
        };
    });
}
