import {ITransportRoute} from 'types/common/seoPages/ITransportRoutesBlock';

import {getRouteUrl} from 'utilities/url/getRouteUrl';
import {getTransportIcon} from 'utilities/seo/getTransportIcon';

import {ILinksListItem} from 'components/LinksList/components/LinksListItem';

export function prepareTransportRoutesItems(
    items: ITransportRoute[],
): ILinksListItem[] {
    return items.map(item => ({
        icon: getTransportIcon(item.transport),
        text: item.text,
        link: {
            url: getRouteUrl({
                vertical: item.transport,
                fromSlug: item.fromSlug,
                toSlug: item.toSlug,
            }),
            target: '_blank',
        },
        price: item.minPrice,
    }));
}
