export const sessionAppData = {
    get: (key: string): string | null => {
        if (typeof window !== 'undefined' && window.sessionStorage) {
            return window.sessionStorage.getItem(key);
        }

        return null;
    },
    set: (key: string, value: string): void => {
        if (typeof window !== 'undefined' && window.sessionStorage) {
            window.sessionStorage.setItem(key, value);
        }
    },
};
