export const TRUST_SOURCE = 'YandexTrustPaymentForm';

/**
 * https://wiki.yandex-team.ru/billing/trust/dev/ui/deployment/interframecom/#sobytijav2sborka0.0.3
 */
export enum ETrustMessageType {
    /**
     * Новая сумма на оплату после применения скидок
     */
    PAYMENT_PREVIEW = 'payment-preview',

    /**
     * Событие отправляется при загрузке фрейма
     */
    PAYMENT_LOADED_MESSAGE = 'payment-loaded',

    /**
     * Нотификация о статусе платежа. Передается при всех изменениях статуса платежа.
     */
    PAYMENT_STATUS_MESSAGE = 'payment_status',

    /**
     * Успешная оплата/привязка
     */
    PAYMENT_COMPLETE_MESSAGE = 'payment-complete',

    /**
     * Ошибка при оплате/привязке
     */
    PAYMENT_FAIL_MESSAGE = 'payment-fail',

    /**
     * Шлется при наличии счетчика обратного отсчета и обнулении счетчика
     */
    PAYMENT_TIMEOUT = 'payment-timeout',

    /**
     * Ошибка отвязки карты.
     * Пользователю дважды отображается диалоговое окно об отвязке.
     * Пользователь всё ещё может продолжить заполнение формы.
     * Не фатально.
     */
    PAYMENT_UNBIND_FAILURE = 'payment-unbind-failure',

    /**
     * Ошибка во время проверки статуса платежа (ajax-запрос check_payment).
     * Фатально.
     */
    PAYMENT_CHECK_FAILURE = 'payment-check-failure',

    /**
     * Ошибка при обновлении платежа (ajax-запрос).
     * Фатально.
     */
    PAYMENT_UPDATE_FAILURE = 'payment-update-failure',

    /**
     * Неизвестная ошибка (сработал обработчик window.onerror).
     * Не фатально.
     */
    PAYMENT_UNKNOWN_FAILURE = 'payment-unknown-failure',

    /**
     * При успешной привязке/оплате полностью передают ответ ручки check_payment
     */
    PAYMENT = 'payment',

    /**
     * Сообщает, когда изменилась высота фрейма.
     * В том числе при загрузке страницы.
     * Имеет смысл только в мобильной верстке.
     */
    RESIZE = 'on_resize',

    /**
     * Изменение статуса 3ds оплаты
     */
    SECURE_3D_STATUS = '3ds-status',

    /**
     * Событие отправляется перед отправкой формы
     */
    BEFORE_SUBMIT = 'before_submit',
}

export enum ETrustPaymentStatus {
    READY = 'ready',
    WAIT_FOR_NOTIFICATION = 'wait_for_notification',
    SUCCESS = 'success',
}

export enum ETrust3DSStatus {
    STARTED = '3ds-started',
    SUCCESS = '3ds-success',
    ERROR = '3ds-failure',
}
