/* eslint-disable camelcase */

import {
    ETrust3DSStatus,
    ETrustMessageType,
    ETrustPaymentStatus,
    TRUST_SOURCE,
} from './TrustConstants';

export type TTrustMessage = {source: typeof TRUST_SOURCE} & (
    | {
          type:
              | ETrustMessageType.PAYMENT_LOADED_MESSAGE
              | ETrustMessageType.PAYMENT_COMPLETE_MESSAGE
              | ETrustMessageType.PAYMENT_FAIL_MESSAGE
              | ETrustMessageType.PAYMENT_TIMEOUT
              | ETrustMessageType.PAYMENT_UNBIND_FAILURE
              | ETrustMessageType.PAYMENT_CHECK_FAILURE
              | ETrustMessageType.PAYMENT_UPDATE_FAILURE
              | ETrustMessageType.PAYMENT_UNKNOWN_FAILURE;
      }
    | {
          type: ETrustMessageType.PAYMENT_PREVIEW;
          data: ITrustPaymentPreviewData;
      }
    | {
          type: ETrustMessageType.PAYMENT_STATUS_MESSAGE;
          data: ITrustPaymentStatusData;
      }
    | {
          type: ETrustMessageType.PAYMENT;
          data: ITrustPaymentData;
      }
    | {
          type: ETrustMessageType.RESIZE;
          data: ITrustResizeData;
      }
    | {
          type: ETrustMessageType.SECURE_3D_STATUS;
          data: ETrust3DSStatus;
      }
    | {
          type: ETrustMessageType.BEFORE_SUBMIT;
      }
);

export function isPaymentLoaded(message: TTrustMessage): boolean {
    return message.type === ETrustMessageType.PAYMENT_LOADED_MESSAGE;
}

export function isPaymentStarted(message: TTrustMessage): boolean {
    return checkPaymentStatus(
        message,
        ETrustPaymentStatus.WAIT_FOR_NOTIFICATION,
    );
}

export function isPaymentSuccess(message: TTrustMessage): boolean {
    return message.type === ETrustMessageType.PAYMENT_COMPLETE_MESSAGE;
}

export function isPaymentError(message: TTrustMessage): boolean {
    return (
        message.type === ETrustMessageType.PAYMENT_FAIL_MESSAGE ||
        message.type === ETrustMessageType.PAYMENT_CHECK_FAILURE ||
        message.type === ETrustMessageType.PAYMENT_UPDATE_FAILURE ||
        ('data' in message && message.data === ETrust3DSStatus.ERROR)
    );
}

export function isBeforeSubmit(message: TTrustMessage): boolean {
    return message.type === ETrustMessageType.BEFORE_SUBMIT;
}

function checkPaymentStatus(
    message: TTrustMessage,
    status: ETrustPaymentStatus,
): boolean {
    return (
        message.type === ETrustMessageType.PAYMENT_STATUS_MESSAGE &&
        typeof message.data === 'object' &&
        message.data.value === status
    );
}

interface ITrustPaymentPreviewData {
    amount: number;
    original_amount: number;
    discounts: number;
    promocode: unknown;
}

interface ITrustPaymentStatusData {
    value: ETrustPaymentStatus;
}

interface ITrustResizeData {
    height: number;
}

interface ITrustPaymentData {
    rrn: string;
    uid: string;
    payment_method: string;
    terminal_id: number;
    two_stage: number;
    currency: string;
    is_binding_payment: number;
    paysys_sent_ts: string;
    fiscal_status: string;
    cardholder: string;
    balance_service_id: number;
    template_tag: string;
    transaction_id: string;
    payment_type: string;
    status: string;
    fake_payment: number;
    status_desc: string;
    payment_method_full: string;
    approval_code: string;
    payment_mode: unknown;
    purchase_token: string;
    payment_id: string;
    payment_dt: string;
    payment_result_dt: string;
    binding_result: string;
    masked_pan: string;
    amount: string;
    paysys_ready_ts: string;
    payment_timeout: string;
    start_dt: string;
}
