/**
 * Функция для последовательной сортировки (несколько уровней)
 * @param cmp - функция для сортировки
 **/

export default function sortBy(cmp: (a: any, b: any) => number) {
    /**
     * @param a - Первый элемент сравнения
     * @param b - Второй элемент сравнения
     */
    function comparator(a: any, b: any) {
        return cmp(a, b);
    }

    /**
     * Фукнция, для следующего уровня сортирвки
     * @param cmp2 - функция для сортировки
     */
    comparator.thenBy = (cmp2: (a: any, b: any) => number) => {
        return sortBy((a, b) => cmp(a, b) || cmp2(a, b));
    };

    return comparator;
}
