import {parse} from 'query-string';

import history from 'utilities/browserHistory/browserHistory';
import {sessionAppData} from 'utilities/sessionAppData/sessionAppData';

export function storeSrcParams(): void {
    if (!history) {
        return;
    }

    const {srcParams} = parse(history.location.search);

    if (srcParams) {
        sessionAppData.set('srcParams', srcParams.toString());
    }
}

export function getStoredSrcParams(): string | null {
    return sessionAppData.get('srcParams');
}

export function getStoredSrcQueryParams(): Record<'srcParams', string> | null {
    const srcParams = getStoredSrcParams();

    return srcParams ? {srcParams} : null;
}
