export function getStorageItem(storage: Storage | undefined, key: string): any {
    if (!storage) {
        return null;
    }

    try {
        const json = storage.getItem(key);

        if (json) {
            return JSON.parse(json);
        }

        return null;
    } catch (e) {
        return null;
    }
}

export function saveStorageItem(
    storage: Storage | undefined,
    key: string,
    value: any,
): boolean {
    if (!storage) {
        return false;
    }

    try {
        storage.setItem(key, JSON.stringify(value));

        return true;
    } catch (e) {
        return false;
    }
}

export function removeStorageItem(
    storage: Storage | undefined,
    key: string,
): void {
    if (!storage) {
        return;
    }

    try {
        storage.removeItem(key);
    } catch (e) {}
}
