import {IDevice} from 'reducers/common/commonReducerTypes';

/**
 * Вернёт объект с модификаторами для устройств
 * @see миксины src/styles/devices.scss
 */
export function deviceMods(
    className: string,
    deviceType: IDevice,
    modifier?: string,
): object {
    const modifierPart = modifier ? `_${modifier}` : '';

    return {
        [`${className}_mobile${modifierPart}`]: deviceType.isMobile,
        [`${className}_desktop${modifierPart}`]: deviceType.isDesktop,
    };
}

export function deviceModMobile(
    className: string,
    deviceType: IDevice,
): object {
    return {
        [`${className}_mobile`]: deviceType.isMobile,
    };
}

export function deviceModDesktop(
    className: string,
    deviceType: IDevice,
): object {
    return {
        [`${className}_desktop`]: deviceType.isDesktop,
    };
}
