import {TDeparture} from 'server/api/LevelTravelApi/types';

export interface IFindMatchedDepartureParams {
    departures: TDeparture[];
    departureName: string;
}

export default function findMatchedDeparture({
    departures,
    departureName,
}: IFindMatchedDepartureParams): TDeparture | null {
    return (
        departures.find(
            dep =>
                dep.name_ru.toLocaleLowerCase() ===
                    departureName.toLowerCase() ||
                dep.name_en.toLocaleLowerCase() === departureName.toLowerCase(),
        ) || null
    );
}
