import {RouteComponentProps} from 'react-router-dom';
import {StringifyOptions} from 'query-string';

import browserHistory from 'utilities/browserHistory/browserHistory';
import getUrlWithUpdatedQueryByLocation from 'utilities/url/getUrlWithUpdatedQueryByLocation';

export interface IUpdateLocationWithQueryOption {
    replace?: boolean;
    useOnlyNextQuery?: boolean;
    stringifyOptions?: StringifyOptions;
    needSaveLocationState?: boolean;
    scrollTop?: number | null;
}

export default function updateLocationWithQuery(
    query: Record<string, any>,
    location?: RouteComponentProps['location'],
    {
        replace = false,
        useOnlyNextQuery,
        stringifyOptions,
        needSaveLocationState,
        scrollTop,
    }: IUpdateLocationWithQueryOption = {},
): void {
    if (!browserHistory) {
        return;
    }

    const url = getUrlWithUpdatedQueryByLocation(query, location, {
        useOnlyNextQuery,
        stringifyOptions,
    });

    let locationState = needSaveLocationState
        ? browserHistory.location.state
        : undefined;

    if (scrollTop !== undefined) {
        locationState = {...locationState, scrollTop};
    }

    if (replace) {
        browserHistory.replace(url, locationState);
    } else {
        browserHistory.push(url, locationState);
    }
}
