import {IUrlQuery} from 'utilities/url/types';

export function decodeParams(params: IUrlQuery): IUrlQuery {
    return Object.entries(params).reduce(
        (res, [key, value]) => ({
            ...res,
            [key]: decodeURIComponent(value),
        }),
        {},
    );
}
